/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureUtils {
    public static void registerUrlTexture(@NotNull String textureUrl, @NotNull class_2960 textureId, @Nullable Path texturePath, boolean removeAfterReg) {
        Path cachedTexturePath = TextureUtils.getCachedTexturePath(texturePath, textureUrl);
        if (cachedTexturePath == null) {
            return;
        }
        class_1046 playerSkinTexture = new class_1046(cachedTexturePath.toFile(), textureUrl, class_1068.method_4649(), true, () -> {
            block7: {
                if (!removeAfterReg) {
                    return;
                }
                try {
                    if (cachedTexturePath.toFile().exists()) {
                        Files.delete(cachedTexturePath);
                    }
                }
                catch (FileSystemException fileSystemException) {
                }
                catch (FileNotFoundException e) {
                    if (MyTotemDollClient.getConfig().isDebugLogEnabled()) {
                        MyTotemDollClient.LOGGER.warn("Failed to find temp texture file at {} to delete it", (Object)cachedTexturePath);
                    }
                }
                catch (Exception e) {
                    if (!MyTotemDollClient.getConfig().isDebugLogEnabled()) break block7;
                    MyTotemDollClient.LOGGER.error("Failed to delete temp texture: ", (Throwable)e);
                }
            }
        });
        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)playerSkinTexture);
    }

    @Nullable
    private static Path getCachedTexturePath(@Nullable Path texturePath, String textureUrl) {
        if (texturePath != null) {
            return texturePath;
        }
        Path defCacheFolder = FabricLoader.getInstance().getGameDir().resolve(".cache");
        File cacheFolderFile = defCacheFolder.toFile();
        if (!cacheFolderFile.exists() && !cacheFolderFile.mkdirs()) {
            return null;
        }
        return defCacheFolder.resolve(String.format("%s.png", Math.abs(textureUrl.hashCode())));
    }
}

